import { createMountWrapperFactory } from 'tachyon-test-utils';
import {
  NetzDGForm,
  mockReportWizardContext,
  reportWizardContext,
} from '../../components';
import type { ReportContentNetzDGInput } from '../../gql-types';
import { NetzDG } from '.';

describe(NetzDG, () => {
  const setup = createMountWrapperFactory(NetzDG, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        setFormValue: jest.fn(),
      }),
    ],
  });
  it('calls setFormValue with undefined', () => {
    const { contexts, wrapper } = setup();
    wrapper.find(NetzDGForm).props().onFormValidationChange?.();

    expect(
      contexts.get(reportWizardContext).setFormValue,
    ).toHaveBeenLastCalledWith({ netzDGArgs: undefined });
  });

  it('calls setFormValue with valid NetzDG form', () => {
    const { contexts, wrapper } = setup();
    const mockForm: ReportContentNetzDGInput = {
      contentDirectedTo: 'ME',
      reporterEmail: 'a@a.com',
      reportingFor: 'MYSELF',
    };
    wrapper.find(NetzDGForm).props().onFormValidationChange?.(mockForm);

    expect(
      contexts.get(reportWizardContext).setFormValue,
    ).toHaveBeenLastCalledWith({ netzDGArgs: mockForm });
  });
});
