import type { FC } from 'react';
import { useContext } from 'react';
import { useIntl } from 'tachyon-intl';
import { Layout, Title, TitleSize } from 'twitch-core-ui';
import { ReasonSelect, reportWizardContext } from '../../components';

type ReasonProps = {};

export const Reason: FC<ReasonProps> = () => {
  const {
    disclosureText,
    next,
    reasons,
    setHideBackButton,
    setShowFormPreview,
  } = useContext(reportWizardContext);
  const { formatMessage } = useIntl();

  return (
    <Layout fullWidth>
      <Layout margin={{ bottom: 1 }}>
        <Title size={TitleSize.ExtraSmall}>
          {formatMessage('Why are you submitting this report?', 'ReasonLabel')}
        </Title>
      </Layout>
      <ReasonSelect
        allReasons={reasons.allReasons}
        disclosureText={disclosureText}
        mainReasons={reasons.mainReasons}
        onExitSearchOther={() => {
          setShowFormPreview(true);
          setHideBackButton(false);
        }}
        onSearchOther={() => {
          setShowFormPreview(false);
          setHideBackButton(true);
        }}
        onSelect={(reasonID, detailedReasonID) => {
          setShowFormPreview(true);
          setHideBackButton(false);
          next({ detailedReason: detailedReasonID, reason: reasonID });
        }}
      />
    </Layout>
  );
};

Reason.displayName = 'Reason';
