import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Button } from 'twitch-core-ui';
import {
  ReasonSelect,
  mockReportWizardContext,
  reportWizardContext,
} from '../../components';
import { ReportWizardStep, mockReasons } from '../../models';
import { Reason } from '.';

describe(Reason, () => {
  const setup = createMountWrapperFactory(Reason, undefined, {
    wrappingContexts: () => [
      mockReportWizardContext({
        currentStep: ReportWizardStep.Reason,
        next: jest.fn(),
        previous: jest.fn(),
        reasons: mockReasons,
        setFormValue: jest.fn(),
        setHideBackButton: jest.fn(),
        setShowFormPreview: jest.fn(),
      }),
    ],
  });

  it('sets form value, and calls next to wizard context when a reason is selected', () => {
    const { contexts, wrapper } = setup();

    wrapper.find(Button).first().simulate('click');
    expect(contexts.get(reportWizardContext).next).toHaveBeenCalledWith({
      reason: mockReasons.mainReasons[0].id,
    });
  });

  it('hides form preview when Other button is clicked', () => {
    const { contexts, wrapper } = setup();

    wrapper.find({ children: 'Other' }).find(Button).simulate('click');
    expect(
      contexts.get(reportWizardContext).setShowFormPreview,
    ).toHaveBeenCalledTimes(1);
  });

  it('sets showFormPreview hideBackButton to default setting when exiting search', () => {
    const { contexts, wrapper } = setup();

    wrapper.find(ReasonSelect).props().onExitSearchOther();
    expect(
      contexts.get(reportWizardContext).setShowFormPreview,
    ).toHaveBeenCalledWith(true);
    expect(
      contexts.get(reportWizardContext).setHideBackButton,
    ).toHaveBeenCalledWith(false);
  });
});
