# Tachyon Auth

This package provides a client side implementation for login at Twitch.
Presently, only the Device Code Flow (DCF) is supported.

There is a complementary package `tachyon-auth-server` which provides
corresponding server side utils.

## General Overview

Ultimately, login flows yield an `auth-token`, which is used to authenticate
with services at Twitch. The `auth-token` is stored via cookie and read by the
client and server.

We
[do not store a refresh token](https://git.xarth.tv/emerging-platforms/tachyon/blob/main/packages/tachyon-core/auth/src/interpol/index.ts#L54-L55)
because tokens do not currently expire.

When making authenticated calls to GQL, the suggested error handling pattern for
applications is to clear the `auth-token` storage and retry the request
unauthenticated if GQL returns a 403 Forbidden status code.

## DCF

Here is an overview of the relevant
[interpol](https://docs.google.com/document/d/1kYSBfyqzsx2qoUWP4pBM1tJ2zH5wnS-NdSxoyIDbMaE/edit#heading=h.4b8r44m4d03o)
(backing service owned by Identity) endpoints.

[Tracking Spec](https://docs.google.com/document/d/18Pgu0hiRMHBzI9OlfpkMf4sHryFAdTIKV39Gj662des/edit?ts=5fad87f3#)
