import {
  GLOBAL_COOKIE_NAMES,
  clearCookieValue,
  getAndExtendCookieValue,
  setCookieValue,
} from 'tachyon-utils-twitch';
import type { OAuthTokenResponse } from '../../types';

/**
 * Gets the auth token from cookies.
 */
function getAuthTokenInBrowser(): string | null {
  return (
    getAndExtendCookieValue({
      name: GLOBAL_COOKIE_NAMES.AUTH_TOKEN_COOKIE_NAME,
    }) ?? null
  );
}

/**
 * Writes the auth token to a cookie
 */
export function setAuthTokenInBrowser(
  token: Pick<OAuthTokenResponse, 'access_token'>,
): void {
  setCookieValue({
    name: GLOBAL_COOKIE_NAMES.AUTH_TOKEN_COOKIE_NAME,
    value: token.access_token,
  });
}

/**
 * Removes the auth token cookie
 */
export function clearAuthTokenInBrowser(): void {
  clearCookieValue({
    name: GLOBAL_COOKIE_NAMES.AUTH_TOKEN_COOKIE_NAME,
  });
}

export type CurrentUser =
  | {
      authorizationToken: null;
      isLoggedIn: false;
    }
  | {
      authorizationToken: string;
      isLoggedIn: true;
    };

export function getCurrentUserInBrowser(): CurrentUser {
  // If identity stops issuing permanent tokens we'll want isLoggedIn to check
  // for the token expiration and not just the presence of the auth-token cookie
  const authorizationToken = getAuthTokenInBrowser();

  return authorizationToken
    ? { authorizationToken, isLoggedIn: true }
    : { authorizationToken: null, isLoggedIn: false };
}
