import {
  MAX_COOKIE_AGE,
  clearCookieValue,
  getAndExtendCookieComplexValue,
  setCookieComplexValue,
} from 'tachyon-utils-twitch';

/**
 * The name of the user cookie for Tachyon clients. This naming mirrors the 'twilight-user' naming convention from Twilight.
 */
export const TACHYON_USER_COOKIE_NAME = 'tachyon-user';

type TachyonUserV1 = {
  id: string;
  login: string;
  version: '1';
};

// These can be extended for new versioned schemas, eg:
// TachyonUser = TachyonUserV1 | TachyonUserV2
export type TachyonUser = TachyonUserV1;

// istanbul ignore next: trivial
/**
 * Gets the user from the tachyon-user cookie.
 */
export function getTachyonUserCookieInBrowser(): TachyonUser | undefined {
  return getAndExtendCookieComplexValue({ name: TACHYON_USER_COOKIE_NAME });
}

// istanbul ignore next: trivial
/**
 * Writes the user to the tachyon-user cookie
 */
export function setTachyonUserCookieInBrowser(user: TachyonUser): void {
  setCookieComplexValue({
    name: TACHYON_USER_COOKIE_NAME,
    opts: { maxAge: MAX_COOKIE_AGE },
    value: user,
  });
}

// istanbul ignore next: trivial
/**
 * Removes the auth token cookie
 */
export function clearTachyonUserCookieInBrowser(): void {
  clearCookieValue({
    name: TACHYON_USER_COOKIE_NAME,
  });
}
