import { chunk } from 'tachyon-utils-stdlib';
import type { OAuthDeviceCodeResponse } from '../types';

export function formattedUserCode({
  user_code,
}: Pick<OAuthDeviceCodeResponse, 'user_code'>): string {
  return chunk(user_code.split(''), 4)
    .map((x: string[]) => x.join(''))
    .join('-');
}

/**
 * Adds the user_code as a query param on the verification_uri
 *
 * @throws for invalid URLs
 */
export function getQrCodeUri({
  user_code,
  verification_uri,
}: Pick<OAuthDeviceCodeResponse, 'user_code' | 'verification_uri'>): string {
  const url = new URL(verification_uri);
  url.searchParams.set('device-code', user_code);
  url.searchParams.set('device-metadata', 'qr_code');
  return url.href;
}
