import { formattedUserCode, getQrCodeUri } from '.';

describe(formattedUserCode, () => {
  it('kebab cases the device code into groups of 4 digits', () => {
    expect(formattedUserCode({ user_code: '12345678' })).toEqual('1234-5678');
  });
});

describe(getQrCodeUri, () => {
  it('adds device-code query param', () => {
    expect(
      getQrCodeUri({
        user_code: '12345678',
        verification_uri: 'https://www.twitch.tv/',
      }),
    ).toEqual(
      'https://www.twitch.tv/?device-code=12345678&device-metadata=qr_code',
    );
  });

  it('throws error upon invalid verification_uri', () => {
    expect(() =>
      getQrCodeUri({
        user_code: '12345678',
        verification_uri: 'bigAndy',
      }),
    ).toThrow();
  });
});
