import { useContext } from 'react';
import type { CurrentUserContext } from '../../CurrentUserRoot';
import { currentUserContext } from '../../CurrentUserRoot';

// istanbul ignore next: trivial
/**
 * Hook for accessing and manipulating the current user session.
 *
 * Caveats:
 * - login, logout and token functions only work client side.
 */
export function useCurrentUser(): CurrentUserContext {
  return useContext(currentUserContext);
}
