import { getDeviceCode, getToken } from '.';

jest.mock('tachyon-utils-stdlib', () => ({
  poll: jest.fn(),
}));

describe(getDeviceCode, () => {
  afterEach(() => {
    fetchMock.resetMocks();
  });

  it('requests the device code with the expected scopes', async () => {
    fetchMock.mockResponse(JSON.stringify({}), { status: 200 });
    await getDeviceCode('client-id');

    expect(fetchMock).toHaveBeenCalledWith(
      'https://id.twitch.tv/oauth2/device',
      {
        body: 'client_id=client-id&scopes=channel_read%20chat%3Aread%20user_blocks_edit%20user_blocks_read%20user_follows_edit%20user_read',
        headers: {
          Accept: 'application/json',
          'Content-Type': 'application/x-www-form-urlencoded',
        },
        method: 'POST',
      },
    );
  });

  it('throws when response is anything other than 200', async () => {
    fetchMock.mockResponse(JSON.stringify({}), { status: 400 });

    await expect(getDeviceCode('client-id')).rejects.toEqual({});
  });
});

describe(getToken, () => {
  afterEach(() => {
    fetchMock.resetMocks();
  });

  it('requests the token for a device code', async () => {
    fetchMock.mockResponse(JSON.stringify({}), { status: 200 });
    await getToken('client-id', 'device-code');

    expect(fetchMock).toHaveBeenCalledWith(
      'https://id.twitch.tv/oauth2/token',
      {
        body: 'client_id=client-id&device_code=device-code&grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Adevice_code',
        headers: {
          Accept: 'application/json',
          'Content-Type': 'application/x-www-form-urlencoded',
        },
        method: 'POST',
      },
    );
  });

  it('throws when response is anything other than 200', async () => {
    fetchMock.mockResponse(JSON.stringify({}), { status: 400 });

    await expect(getToken('client-id', 'device-code')).rejects.toEqual({});
  });
});
