export type OAuthDeviceCodeResponse = {
  device_code: string;
  expires_in: number;
  interval: number;
  user_code: string;
  verification_uri: string;
};

export type OAuthTokenResponse = {
  access_token: string;
  // The device-metadata string is passed to the backend as a parameter on the
  // verification endpoint, and then given back to us on a successful
  // verification.
  device_metadata: string;
  // Currently unused. Tokens don't expire yet.
  expires_in: number;
  // Currently unused. Identity has not yet implemented a token refresh flow.
  refresh_token: string;
  token_type: string;
};

export type DeviceCodeInfo = {
  // A user-friendly version of the userCode
  formattedUserCode: string;
  // The uri we put in the QR code (with some extra data)
  qrCodeUri: string;
  // The 8 digit code the user needs to type in the verification page
  userCode: string;
  // The uri we show to the user (which is a fallback for the QR code)
  verificationUri: string;
};
