# Tachyon-Chat UI

An SSR compatible Twitch Chat UI implementation via React, Styled Components,
Core-UI, tachyon-intl, and Web Workers.

```tsx
yarn add tachyon-chat-ui tachyon-chat tachyon-intl
```

## How To Use

### Add Polyfills

Tachyon-Chat relies on the use of [tachyon-polyfill](../polyfill/README.md) for
its web worker.

### Consume Translations

Tachyon-Chat contains translations that must be consumed by its consumer.

### Create And Build The Web Worker

1. Create `chat.worker.js`, a Web Worker file, in your application containing
   the following:

   ```js
   import { ChatService } from 'tachyon-chat';
   new ChatService();
   ```

2. Add app build config for the web worker. If consuming as part of a webpack
   built app, use
   [worker-loader](https://github.com/webpack-contrib/worker-loader).

### Consume The React Components

```tsx
import type { FC } from 'react';
import { Layout, Overflow } from 'twitch-core-ui';
import { ChatWorkerInstance } from 'tachyon-chat';
import { ChatPane, ChatRoot } from 'tachyon-chat-ui';
// @ts-expect-error: WebWorkers are necessarily (untyped) JS
import ChatWorker from './chat.worker';

const ChannelPage: FC = () => {
  return (
    <Layout fullHeight overflow={Overflow.Scroll}>
    <ChatRoot
      channel={...}
      clientApiId={...}
      getWorker={() => (new ChatWorker() as ChatWorkerInstance)}
    >
      <ChatPane />
    </ChatRoot>
    </Layout>
  );
};
```

### Creating A Custom Chat Message Consume

Some consumers may not want the default Chat UI provided by `ChatPane`. This
package also provides `withChat`, an HOC, which can be used to manually consume
messages. By default, the 100 most recent messages will be provided to the
consumer. The consumer may also pause and unpause chat through the provided
callbacks.

```tsx
import type { FC } from 'react';
import { ChatMessage, ChatProps, withChat } from 'tachyon-chat-ui';
import { useIntl } from 'tachyon-intl';

interface ChatConsumerProps extends ChatProps {}

const ChatConsumerBase: FC = ({ chatMessages, pause, unpause }) => {
  const intl = useIntl();
  return (
    <ul>
      {chatMessages.map(message => (
        {/* ChatMessage renders the content in an <li> */}
        <ChatMessage className={className} intl={intl} key={message.id} message={message} />
      ))}
    </ul>
  );
};
const ChatConsumer = withChat(ChatConsumerBase);
```
