import type { FC } from 'react';
import styled from 'styled-components';
import type { Badge } from 'tachyon-chat';
import { ChatImage } from '../ChatImage';

/**
 * This is the native size of an badge image.
 */
export const DEFAULT_BADGE_SIZE = '18px';

export interface BadgeListProps {
  /**
   * An optional string for the height/width of badge images. This must include
   * units as well: e.g. 18px (which is the default).
   */
  badgeSize: string;
  badges: Badge[];
}

const ScBadgeImage = styled(ChatImage)`
  margin-right: 0.3rem;
`;

export const BadgeList: FC<BadgeListProps> = ({ badgeSize, badges }) => (
  <>
    {badges.map((badge) => (
      <ScBadgeImage
        alt={badge.alt}
        key={badge.alt}
        size={badgeSize}
        srcKey="1x"
        srcSet={badge.images}
      />
    ))}
  </>
);

BadgeList.displayName = 'BadgeList';
