import type { FC } from 'react';
import type { MessageData } from 'tachyon-chat';
import { Color, CoreText, TextType } from 'twitch-core-ui';
import type { BadgeListProps } from '../BadgeList';
import { BadgeList } from '../BadgeList';
import { Username } from '../Username';

interface ChatActionProps extends Pick<BadgeListProps, 'badgeSize'> {
  message: MessageData;
  parts: JSX.Element | JSX.Element[];
}

// Prettier will try to convert this to non-quoted empty space if we inline in JSX
const ACTION_SEPARATOR_TEXT = ' ';

// we use inline styles due to the "infinite" variety of user colors and the
// thrash this would otherwise cause for styled-components
/* eslint-disable react/forbid-dom-props */
export const ChatAction: FC<ChatActionProps> = ({
  badgeSize,
  message: { badges, user },
  parts,
}) => {
  const style = user.color ? { color: user.color } : undefined;
  return (
    <>
      <BadgeList badgeSize={badgeSize} badges={badges} />
      <Username user={user} />
      <CoreText color={Color.Base} type={TextType.Span}>
        <span style={style}>
          <span key="separator">{ACTION_SEPARATOR_TEXT}</span>
          {parts}
        </span>
      </CoreText>
    </>
  );
};

ChatAction.displayName = 'ChatAction';
