import type { FC } from 'react';
import styled from 'styled-components';
import type { EmoteData } from 'tachyon-chat';
import { CoreText, TextType } from 'twitch-core-ui';
import { ChatImage } from '../ChatImage';

/**
 * This is the native size of an emote image.
 */
export const DEFAULT_EMOTE_SIZE = '28px';

export interface ChatEmoteProps extends EmoteData {
  /**
   * String for the height/width of emote images. This must include units as
   * well: e.g. 28px (which is the default).
   */
  emoteSize: string;
}

const ScEmoteImage = styled(ChatImage)`
  margin: -0.4rem 0;
`;

const ScCheerAmountSpan = styled.span<{ cheerColor: EmoteData['cheerColor'] }>`
  color: ${(props) => props.cheerColor};
`;

export const ChatEmote: FC<ChatEmoteProps> = ({
  alt,
  cheerAmount,
  cheerColor,
  emoteSize,
  images,
}) => (
  <>
    <ScEmoteImage alt={alt} size={emoteSize} srcKey="1x" srcSet={images} />
    {cheerAmount ? (
      <CoreText type={TextType.Strong}>
        <ScCheerAmountSpan cheerColor={cheerColor}>
          {cheerAmount}
        </ScCheerAmountSpan>
      </CoreText>
    ) : null}
  </>
);

ChatEmote.displayName = 'ChatEmote';
