import type { FC } from 'react';
import styled from 'styled-components';

interface ScChatImageProps {
  /**
   * String with units
   */
  size: string;
}

function getSize({ size }: ScChatImageProps): string {
  return `
    height: ${size};
    width: ${size};
  `;
}

const ScChatImage = styled.img<ScChatImageProps>`
  ${getSize}
  vertical-align: middle;
`;

interface ChatImageProps extends ScChatImageProps {
  alt?: string | undefined;
  className?: string;
  srcKey: string;
  srcSet: { [scale: string]: string };
}

export const ChatImage: FC<ChatImageProps> = ({
  alt,
  className,
  size,
  srcKey,
  srcSet,
}) => (
  <ScChatImage
    alt={alt}
    className={className}
    size={size}
    src={srcSet[srcKey]}
    srcSet={Object.keys(srcSet)
      .map((scale) => `${srcSet[scale]} ${scale}`)
      .join(',')}
  />
);

ChatImage.displayName = 'ChatImage';
