import type { FC } from 'react';
import type { ModerationEvent } from 'tachyon-chat';
import type { TwitchIntl } from 'tachyon-intl';
import { useIntl } from 'tachyon-intl';
import { Color, CoreText, TextType } from 'twitch-core-ui';

interface ChatModerationProps {
  message: ModerationEvent;
}

function formatModerationMessage(
  intl: TwitchIntl,
  message: ModerationEvent,
): string {
  const { formatMessage } = intl;
  if (message.type === 'BAN') {
    if (message.reason) {
      return formatMessage(
        '{username} has been banned. Reason: {reason}',
        {
          reason: message.reason,
          username: message.username,
        },
        'ChatMessage',
      );
    }

    return formatMessage(
      '{username} has been banned.',
      {
        username: message.username,
      },
      'ChatMessage',
    );
  }
  if (message.reason) {
    return formatMessage(
      '{username} has been timed out for {duration} seconds. Reason: {reason}',
      {
        duration: message.duration,
        reason: message.reason,
        username: message.username,
      },
      'ChatMessage',
    );
  }

  return formatMessage(
    '{username} has been timed out for {duration} seconds.',
    {
      duration: message.duration,
      username: message.username,
    },
    'ChatMessage',
  );
}

export const ChatModeration: FC<ChatModerationProps> = ({ message }) => {
  const intl = useIntl();

  return (
    <CoreText color={Color.Alt} type={TextType.Span}>
      {formatModerationMessage(intl, message)}
    </CoreText>
  );
};

ChatModeration.displayName = 'ChatModeration';
