import { buildTestModerationEvent } from 'tachyon-chat';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { ChatModeration } from '.';

describe(ChatModeration, () => {
  const setup = createMountWrapperFactory(ChatModeration, () => ({
    message: buildTestModerationEvent(),
  }));

  it('renders a TIMEOUT with reason moderation', () => {
    const { wrapper } = setup({
      message: buildTestModerationEvent(undefined, undefined),
    });
    expect(wrapper).toHaveText(
      'voxel has been timed out for 0.001 seconds. Reason: for being too awesome',
    );
  });

  it('renders a TIMEOUT without reason moderation', () => {
    const { wrapper } = setup({
      message: buildTestModerationEvent(undefined, undefined, null),
    });
    expect(wrapper).toHaveText('voxel has been timed out for 0.001 seconds.');
  });

  it('renders a BAN with reason moderation', () => {
    const { wrapper } = setup({
      message: buildTestModerationEvent(undefined, 'BAN'),
    });
    expect(wrapper).toHaveText(
      'voxel has been banned. Reason: for being too awesome',
    );
  });

  it('renders a BAN without reason moderation', () => {
    const { wrapper } = setup({
      message: buildTestModerationEvent(undefined, 'BAN', null),
    });
    expect(wrapper).toHaveText('voxel has been banned.');
  });
});
