import type { FC } from 'react';
import type { MessageData } from 'tachyon-chat';
import { Color, CoreText, TextType } from 'twitch-core-ui';
import type { BadgeListProps } from '../BadgeList';
import { BadgeList } from '../BadgeList';
import { Username } from '../Username';

interface ChatPostProps extends Pick<BadgeListProps, 'badgeSize'> {
  message: MessageData;
  parts: JSX.Element | JSX.Element[];
}

export const ChatPost: FC<ChatPostProps> = ({ badgeSize, message, parts }) => {
  return (
    <>
      <BadgeList badgeSize={badgeSize} badges={message.badges} />
      <Username user={message.user} />
      <CoreText color={Color.Base} type={TextType.Span}>
        <span>
          <span key="separator">{' : '}</span>
          {parts}
        </span>
      </CoreText>
    </>
  );
};

ChatPost.displayName = 'ChatPost';
