import type { FC } from 'react';
import type { MessageEventUserData } from 'tachyon-chat';
import { getFormattedUserDisplayName } from 'tachyon-utils-twitch';
import { Color, CoreText, TextType } from 'twitch-core-ui';

type UsernameProps = {
  user: MessageEventUserData;
};

// istanbul ignore next: trivial
// we use inline styles due to the "infinite" variety of user colors and the
// thrash this would otherwise cause for styled-components
/* eslint-disable react/forbid-dom-props */
export const Username: FC<UsernameProps> = ({ user }) => {
  const style = user.color ? { color: user.color } : undefined;
  return (
    <CoreText color={Color.Base} key="username" type={TextType.Strong}>
      <span style={style}>
        {getFormattedUserDisplayName({
          displayName: user.usernameDisplay,
          login: user.username,
        })}
      </span>
    </CoreText>
  );
};

Username.displayName = 'Username';
