import type { FC } from 'react';
import { useRef } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import type { Padding } from 'twitch-core-ui';
import {
  Display,
  FlexDirection,
  InjectLayout,
  JustifyContent,
  Layout,
} from 'twitch-core-ui';
import type { ChatMessageProps } from '../ChatMessage';
import { ChatMessage } from '../ChatMessage';
import { useChat } from '../context';

const ScChatContainer = styled(Layout)`
  max-height: 100%;
`;

type ChatPaneProps = Pick<ChatMessageProps, 'sizes'> & {
  messagePadding?: Padding;
  onFirstMessage?: () => void;
  panePadding?: Padding;
};

export const ChatPane: FC<ChatPaneProps> = ({
  messagePadding,
  onFirstMessage,
  panePadding,
  sizes,
}) => {
  const intl = useIntl();
  const hasReportedFirstMessage = useRef(false);
  const { chatMessages } = useChat();

  if (chatMessages.length > 0 && !hasReportedFirstMessage.current) {
    onFirstMessage?.();
    hasReportedFirstMessage.current = true;
  }

  return (
    <ScChatContainer
      as="ul"
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      justifyContent={JustifyContent.End}
      // TODO CORE-UI-TYPES: Update core-ui types to accept undefined
      // https://jira.xarth.tv/browse/EMP-4748
      padding={panePadding as Padding}
    >
      {chatMessages.map((message) => {
        // Inject style changes to avoid extra render depth in high-throughput DOM area
        return (
          <InjectLayout
            flexShrink={0}
            key={message.id}
            // TODO CORE-UI-TYPES: Update core-ui types to accept undefined
            // https://jira.xarth.tv/browse/EMP-4748
            padding={messagePadding as Padding}
          >
            <ChatMessage intl={intl} message={message} sizes={sizes} />
          </InjectLayout>
        );
      })}
    </ScChatContainer>
  );
};

ChatPane.displayName = 'ChatPane';
