import { datatype } from 'faker';
import { buildTestMessageEvent } from 'tachyon-chat';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { ChatMessage } from '../ChatMessage';
import type { ChatContext } from '../context';
import { chatContext } from '../context';
import { ChatPane } from '.';

describe(ChatPane, () => {
  function chatContextWithMessages(count: number): ChatContext {
    return {
      chatMessages: Array.from(Array(count)).map(() => buildTestMessageEvent()),
      pause: jest.fn(),
      unpause: jest.fn(),
    };
  }

  const setup = createMountWrapperFactory(ChatPane);

  it('renders each provided message', () => {
    const messageCount = datatype.number({ max: 20, min: 1 });
    const { wrapper } = setup(undefined, {
      wrappingContexts: [[chatContext, chatContextWithMessages(messageCount)]],
    });

    expect(wrapper.find(ChatMessage)).toHaveLength(messageCount);
  });

  it('calls onFirstMessage at the right time and only once', () => {
    const onFirstMessage = jest.fn();
    const { updateWrappingContext } = setup(
      { onFirstMessage },
      { wrappingContexts: [[chatContext, chatContextWithMessages(0)]] },
    );
    expect(onFirstMessage).not.toHaveBeenCalled();

    updateWrappingContext(chatContext, chatContextWithMessages(0));
    expect(onFirstMessage).not.toHaveBeenCalled();

    updateWrappingContext(chatContext, chatContextWithMessages(1));
    expect(onFirstMessage).toHaveBeenCalledTimes(1);

    updateWrappingContext(chatContext, chatContextWithMessages(2));
    expect(onFirstMessage).toHaveBeenCalledTimes(1);

    updateWrappingContext(chatContext, chatContextWithMessages(3));
    expect(onFirstMessage).toHaveBeenCalledTimes(1);
  });
});
