import type { Dispatch } from 'react';
import { useReducer } from 'react';
import type { ChatEvent } from 'tachyon-chat';
import { exhaustedCase } from 'tachyon-utils-ts';

export type ChatRootState = {
  chatMessages: ReadonlyArray<ChatEvent>;
  paused: boolean;
};

type ChatRootAction =
  | {
      messages: ReadonlyArray<ChatEvent>;
      type: 'updateMessages';
    }
  | {
      type: 'pause' | 'reset' | 'unpause';
    };

export const initialChatRootState: ChatRootState = {
  chatMessages: [],
  paused: false,
};

export function chatRootReducer(
  state: ChatRootState,
  action: ChatRootAction,
): ChatRootState {
  switch (action.type) {
    case 'pause':
      return {
        ...state,
        paused: true,
      };
    case 'unpause':
      return {
        ...state,
        paused: false,
      };
    case 'reset':
      return initialChatRootState;
    case 'updateMessages':
      if (state.paused) {
        return state;
      }
      return {
        ...state,
        chatMessages: action.messages,
      };
    default:
      return exhaustedCase(action, state);
  }
}

// istanbul ignore next: trivial
export function useChatRootState(): [ChatRootState, Dispatch<ChatRootAction>] {
  return useReducer(chatRootReducer, initialChatRootState);
}
