import { buildTestMessageEvent } from 'tachyon-chat';
import { chatRootReducer, initialChatRootState } from '.';

describe(chatRootReducer, () => {
  it('handles pause actions', () => {
    expect(chatRootReducer(initialChatRootState, { type: 'pause' })).toEqual({
      ...initialChatRootState,
      paused: true,
    });
  });

  it('handles unpause actions', () => {
    expect(
      chatRootReducer(
        { ...initialChatRootState, paused: true },
        { type: 'unpause' },
      ),
    ).toEqual({
      ...initialChatRootState,
      paused: false,
    });
  });

  it('handles reset actions', () => {
    expect(
      chatRootReducer(
        { chatMessages: [buildTestMessageEvent()], paused: true },
        { type: 'reset' },
      ),
    ).toEqual(initialChatRootState);
  });

  it('handles updateMessages actions when not paused', () => {
    const chatMessages = [buildTestMessageEvent(), buildTestMessageEvent()];
    expect(
      chatRootReducer(initialChatRootState, {
        messages: chatMessages,
        type: 'updateMessages',
      }),
    ).toEqual({
      ...initialChatRootState,
      chatMessages,
    });
  });

  it('handles updateMessages actions when paused', () => {
    const pausedEmptyState = { ...initialChatRootState, paused: true };
    expect(
      chatRootReducer(pausedEmptyState, {
        messages: [buildTestMessageEvent()],
        type: 'updateMessages',
      }),
    ).toEqual(pausedEmptyState);
  });
});
