import { createContext, useContext } from 'react';
import type { ChatEvent } from 'tachyon-chat';

/**
 * Context provided by Tachyon Chat.
 */
export type ChatContext = {
  /**
   * Readonly list of chat events.
   */
  chatMessages: ReadonlyArray<ChatEvent>;
  /**
   * Function that pauses the update from the worker
   */
  pause: () => void;
  /**
   * Function that UNpauses the update from the worker
   */
  unpause: () => void;
};

// istanbul ignore next: trivial
export const chatContext = createContext<ChatContext>({
  chatMessages: [],
  pause: () => undefined,
  unpause: () => undefined,
});

// istanbul ignore next: trivial
export function useChat(): ChatContext {
  return useContext(chatContext);
}
