import type { ComponentType, FC } from 'react';
import { getComponentName } from 'tachyon-utils-react';
import type { ChatContext } from './context';
import { useChat } from './context';

export interface ChatProps extends ChatContext {}

// istanbul ignore next: trivial
export function withChat<P extends ChatProps>(
  Comp: ComponentType<P>,
): FC<Omit<P, keyof ChatProps>> {
  const Chat: FC<Omit<P, keyof ChatProps>> = (props) => {
    const ctx = useChat();
    return <Comp {...(props as P)} {...ctx} />;
  };

  Chat.displayName = `Chat(${getComponentName(Comp)})`;

  return Chat;
}
