# Tachyon-Chat

An SSR compatible Twitch Chat implementation via Web Workers.

```tsx
yarn add tachyon-chat tachyon-intl
```

## How To Use

### Add Polyfills

Tachyon-Chat relies on the use of [tachyon-polyfill](../polyfill/README.md) for
its web worker.

### Create And Build The Web Worker

1. Create `chat.worker.js`, a Web Worker file, in your application containing
   the following:

   ```js
   import { ChatService } from 'tachyon-chat';

   new ChatService();
   ```

2. Add app build config for the web worker. If consuming as part of a webpack
   built app, use
   [worker-loader](https://github.com/webpack-contrib/worker-loader).

## Development Notes

### async/await

This package does not use async/await and instead uses promises directly. This
enables us to avoid relying on certain polyfills, which means smaller bundles
and less configuration for consumers.
