import type { Badge, UserStatePayload } from '../types';
import type { MessageData } from '../utils';
import { createMessageData, idCreator } from '../utils';

export type MessageEventType = 'ACTION' | 'POST';
export interface MessageEvent extends MessageData {
  id: string;
  type: MessageEventType;
}

export function messageEvent(
  type: MessageEventType,
  message: string,
  userstate: UserStatePayload,
  badges: Badge[],
): MessageEvent {
  return {
    ...createMessageData(message, userstate, badges),
    id: userstate.id || idCreator(`${userstate.username}-msg`),
    type,
  };
}
