import { idCreator } from '../utils';

export type ModerationEventType = 'BAN' | 'TIMEOUT';

export interface ModerationEvent {
  duration: number;
  id: string;
  reason: string | null;
  type: ModerationEventType;
  username: string;
}

export function moderationEvent(
  type: ModerationEventType,
  username: string,
  reason: string | null,
  duration?: number,
): ModerationEvent {
  return {
    duration: duration || 0,
    id: idCreator(`${username}-mod`),
    reason,
    type,
    username,
  };
}
