import { idCreator } from '../utils';

export type ConnectionStatusEventType =
  | 'CONNECTED'
  | 'DISCONNECTED'
  | 'RECONNECT';

export type HostingStatusEventType = 'HOSTING' | 'UNHOST';

export type StatusEventType =
  | ConnectionStatusEventType
  | HostingStatusEventType;

export interface ConnectedEvent {
  id: string;
  type: 'CONNECTED';
}

export interface DisconnectedEvent {
  id: string;
  reason: string | undefined;
  type: 'DISCONNECTED';
}

export interface ReconnectEvent {
  id: string;
  type: 'RECONNECT';
}

export interface HostingEvent {
  channel: string;
  hostedChannel: string;
  id: string;
  type: 'HOSTING';
}

export interface UnhostEvent {
  channel: string;
  id: string;
  type: 'UNHOST';
}

export type ConnectionStatusEvent =
  | ConnectedEvent
  | DisconnectedEvent
  | ReconnectEvent;

export type HostingStatusEvent = HostingEvent | UnhostEvent;

export type StatusEvent = ConnectionStatusEvent | HostingStatusEvent;

export function connectedEvent(): ConnectedEvent {
  return {
    id: idCreator('connected'),
    type: 'CONNECTED',
  };
}

export function disconnectedEvent(reason: string): DisconnectedEvent {
  return {
    id: idCreator('disconnected'),
    reason,
    type: 'DISCONNECTED',
  };
}

export function reconnectEvent(): ReconnectEvent {
  return {
    id: idCreator('reconnect'),
    type: 'RECONNECT',
  };
}

export function hostingEvent(
  channel: string,
  hostedChannel: string,
): HostingEvent {
  return {
    channel,
    hostedChannel,
    id: idCreator('hosting'),
    type: 'HOSTING',
  };
}

export function unhostEvent(channel: string): UnhostEvent {
  return {
    channel,
    id: idCreator('unhost'),
    type: 'UNHOST',
  };
}
