import type { Badge, UserStatePayload } from '../types';
import type { MessageData } from '../utils';
import { createMessageData, idCreator } from '../utils';

export type SubscribeEventType = 'RESUBSCRIPTION' | 'SUBSCRIPTION';

export interface SubscriptionEvent {
  channel: string;
  id: string;
  isPrime?: boolean;
  type: 'SUBSCRIPTION';
  username: string;
}

export interface ResubscriptionEvent extends Partial<MessageData> {
  channel: string;
  id: string;
  isPrime?: boolean;
  months?: number;
  type: 'RESUBSCRIPTION';
}

export type SubscribeEvent = ResubscriptionEvent | SubscriptionEvent;

export function subscriptionEvent(
  channel: string,
  username: string,
  isPrime: boolean,
): SubscriptionEvent {
  return {
    channel,
    id: idCreator(`${username}-sub`),
    isPrime,
    type: 'SUBSCRIPTION',
    username,
  };
}

function usernameOnlyMessageData(username: string): Partial<MessageData> {
  return {
    user: {
      color: null,
      username,
      usernameDisplay: username,
    },
  };
}

export function resubscriptionEvent(
  channel: string,
  username: string,
  isPrime: boolean,
  months: number,
  message: string,
  userstate: UserStatePayload,
  badges: Badge[],
): ResubscriptionEvent {
  const messageData = message
    ? createMessageData(message, userstate, badges)
    : usernameOnlyMessageData(username);

  return {
    ...messageData,
    channel,
    id: idCreator(`${username}-sub`),
    isPrime,
    months,
    type: 'RESUBSCRIPTION',
  };
}
