export interface Badge {
  readonly alt: string;
  readonly images: {
    readonly [scale: string]: string;
  };
}

export interface UserStatePayloadBadges {
  readonly [badgeset: string]: string;
}

export interface UserStatePayloadEmotes {
  readonly [emote: string]: string[];
}

export interface UserStatePayload {
  readonly badges: UserStatePayloadBadges | null;
  readonly bits: number | undefined;
  readonly color: string | null;
  readonly 'display-name': string;
  readonly emotes: UserStatePayloadEmotes | null;
  readonly id: string;
  readonly 'user-id': string;
  readonly username: string;
}

interface ConnectMessage {
  command: 'CHAT_WORKER_CONNECTED';
  payload: {
    channelID: string;
    channelLogin: string;
    clientApiId: string;
    polyfillURI: string | null;
  };
}

interface DisconnectMessage {
  command: 'CHAT_WORKER_DISCONNECTED';
}

interface ChangeChannelMessage {
  command: 'CHAT_WORKER_CHANNEL_CHANGED';
  payload: {
    channelID: string;
    channelLogin: string;
  };
}

export type WorkerMessage =
  | ChangeChannelMessage
  | ConnectMessage
  | DisconnectMessage;
