import type { BadgesPayload } from '.';

export const GLOBAL_SUBSCRIBER_VERSION_0_URL =
  'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/1';

export const TEST_CHANNEL_ID = '23161357';

interface BadgesResponse {
  badge_sets: BadgesPayload;
}

const GLOBAL_BADGES_JSON: BadgesResponse = {
  badge_sets: {
    subscriber: {
      versions: {
        0: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: 'Subscriber',
          image_url_1x: GLOBAL_SUBSCRIBER_VERSION_0_URL,
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/3',
          title: 'Subscriber',
        },
        1: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: 'Subscriber',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/19dd8673-124d-4f44-830c-b0f4f9d78635/3',
          title: 'Subscriber',
        },
      },
    },
    warcraft: {
      versions: {
        alliance: {
          click_action: 'visit_url',
          click_url: 'http://warcraftontwitch.tv/',
          description: 'For Lordaeron!',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/c4816339-bad4-4645-ae69-d1ab2076a6b0/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/c4816339-bad4-4645-ae69-d1ab2076a6b0/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/c4816339-bad4-4645-ae69-d1ab2076a6b0/3',
          title: 'Alliance',
        },
        horde: {
          click_action: 'visit_url',
          click_url: 'http://warcraftontwitch.tv/',
          description: 'For the Horde!',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/de8b26b6-fd28-4e6c-bc89-3d597343800d/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/de8b26b6-fd28-4e6c-bc89-3d597343800d/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/de8b26b6-fd28-4e6c-bc89-3d597343800d/3',
          title: 'Horde',
        },
      },
    },
  },
};

const CHANNEL_BADGES_JSON: BadgesResponse = {
  badge_sets: {
    subscriber: {
      versions: {
        0: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: 'Subscriber',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/a8cfb12a-a0c2-4cc2-a5bd-a29184c0e6d8/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/a8cfb12a-a0c2-4cc2-a5bd-a29184c0e6d8/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/a8cfb12a-a0c2-4cc2-a5bd-a29184c0e6d8/3',
          title: 'Subscriber',
        },
        3: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: '3-Month Subscriber',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/4edcfa74-2775-41f4-aedb-4b58ebdb3095/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/4edcfa74-2775-41f4-aedb-4b58ebdb3095/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/4edcfa74-2775-41f4-aedb-4b58ebdb3095/3',
          title: '3-Month Subscriber',
        },
        6: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: '6-Month Subscriber',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/3e64f2b2-47ad-46ab-b581-b9c7fd9055f3/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/3e64f2b2-47ad-46ab-b581-b9c7fd9055f3/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/3e64f2b2-47ad-46ab-b581-b9c7fd9055f3/3',
          title: '6-Month Subscriber',
        },
        12: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: '1-Year Subscriber',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/9fbd7827-60f4-4cce-b8a9-ea9a163eeea5/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/9fbd7827-60f4-4cce-b8a9-ea9a163eeea5/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/9fbd7827-60f4-4cce-b8a9-ea9a163eeea5/3',
          title: '1-Year Subscriber',
        },
        24: {
          click_action: 'subscribe_to_channel',
          click_url: '',
          description: '2-Year Subscriber',
          image_url_1x:
            'https://static-cdn.jtvnw.net/badges/v1/85b53039-7dbf-4b27-9e4f-1ddff749f8b5/1',
          image_url_2x:
            'https://static-cdn.jtvnw.net/badges/v1/85b53039-7dbf-4b27-9e4f-1ddff749f8b5/2',
          image_url_4x:
            'https://static-cdn.jtvnw.net/badges/v1/85b53039-7dbf-4b27-9e4f-1ddff749f8b5/3',
          title: '2-Year Subscriber',
        },
      },
    },
  },
};

function mockGlobalBadges(): void {
  fetchMock.mockResponseOnce(JSON.stringify(GLOBAL_BADGES_JSON));
}

function mockChannelBadges(): void {
  fetchMock.mockResponseOnce(JSON.stringify(CHANNEL_BADGES_JSON));
}

export function mockAllBadges(): void {
  mockGlobalBadges();
  mockChannelBadges();
}
