# Tachyon Cypress

This package contains various utilities that are useful for working with Cypress
at Twitch.

## Adding Commands

There are several commands that extend Cypress functionality. To use them:

```ts
// cypress/support/commands.ts
import { addTacyhonCypressCommands } from 'tachyon-cypress';

addTacyhonCypressCommands();
```

### Command List

#### findSc

    This is a custom child command which finds Sc elements ex. `ScScrollContainer`.
    Takes in a string which is the name of the targeted styled-component, and otherwise works the same as `cy.find()`.

#### getSc

    This is a custom parent command which gets Sc elements ex. `ScScrollContainer`.
    Takes in a string which is the name of the targeted styled-component, and otherwise works the same as `cy.get()`.

### Creating New Commands

To create a new command, add the command inside the
`addTacyhonCypressCommands()` function using the `Cypress.Commands.add`
functionality. Also then adds it type to global type augmentation so that TS
users can see it and get proper intellisense.
