import { Cypress, cy } from 'local-cypress';

declare global {
  // eslint-disable-next-line @typescript-eslint/no-namespace
  namespace Cypress {
    interface Chainable {
      /**
       * Custom child command which finds Sc elements ex. ScScrollContainer
       * @param {string} name of target styled-component
       */
      findSc(key: string): Cypress.Chainable<JQuery<HTMLBodyElement>>;
      /**
       * Custom parent command which gets Sc elements ex. ScScrollContainer
       * @param {string} name of target styled-component
       */
      getSc(key: string): Cypress.Chainable<JQuery<HTMLBodyElement>>;
    }
  }
}

export function addTacyhonCypressCommands(): void {
  Cypress.Commands.add('getSc', (key: string) => {
    cy.get(`[class*=${key}]`, { log: false });
    Cypress.log({ name: 'getSc' });
  });

  Cypress.Commands.add(
    'findSc',
    { prevSubject: true },
    (subject, key: string) => {
      // Subject here is parent command on which find is called
      cy.wrap(subject, { log: false }).find(`[class*=${key}]`, { log: false });
      Cypress.log({ name: 'findSc' });
    },
  );
}
