import type { FC } from 'react';
import { createContext } from 'react';
import { DYNAMIC_SETTINGS_FALLBACK } from './dynamicSettingsResponseProcessor';
import type { DynamicSettings } from './types';

export const dynamicSettingsContext = createContext<DynamicSettings<{}>>(
  DYNAMIC_SETTINGS_FALLBACK,
);

export type DynamicSettingsProps<RawCustomDynamicSettings extends {} = {}> = {
  settings: DynamicSettings<RawCustomDynamicSettings>;
};

// istanbul ignore next: trivial
export const DynamicSettingsRoot: FC<DynamicSettingsProps<{}>> = ({
  children,
  settings,
}) => <dynamicSettingsContext.Provider children={children} value={settings} />;

DynamicSettingsRoot.displayName = 'DynamicSettingsRoot';
