import type { AppEnvironment } from 'tachyon-environment';

/**
 * The base URL for the JSON file that actuator publishes publicly for dynamic settings.
 */
export const BASE_SETTING_URL = 'https://static.twitchcdn.net/config/settings.';

// Currently we don't constrain appGroup or app to avoid requiring package
// updates for new usages.
export interface DynamicSettingsURLGeneratorOpts {
  /**
   * The specific application to target within an appGroup, corrresponding to
   * something like a tachyon app or a twilight subsite.
   */
  app: string;
  /**
   * Environment of the current running application instance. Corresponds to the
   * environment requested from actuator, with `staging` being mapped to `test`.
   */
  appEnvironment: AppEnvironment;
  /**
   * The app's parent grouping, corresponding to something like tachyon or
   * twilight (matching the term platform in Actuator).
   */
  appGroup: string;
}

export function dynamicSettingsURLGenerator({
  app,
  appEnvironment,
  appGroup,
}: DynamicSettingsURLGeneratorOpts): string {
  if (appEnvironment === 'production') {
    return `${BASE_SETTING_URL}${appGroup}.${app}.json`;
  }

  if (appEnvironment === 'staging') {
    return `${BASE_SETTING_URL}${appGroup}.${app}.test.json`;
  }

  return `${BASE_SETTING_URL}${appGroup}.${app}.development.json`;
}
