import { random } from 'faker';
import { dynamicSettingsURLGenerator } from '.';

describe(dynamicSettingsURLGenerator, () => {
  const appGroup = random.alphaNumeric();
  const app = random.alphaNumeric();

  it('handles production environment', () => {
    expect(
      dynamicSettingsURLGenerator({
        app,
        appEnvironment: 'production',
        appGroup,
      }),
    ).toEqual(
      `https://static.twitchcdn.net/config/settings.${appGroup}.${app}.json`,
    );
  });

  it('handles staging environment', () => {
    expect(
      dynamicSettingsURLGenerator({
        app,
        appEnvironment: 'staging',
        appGroup,
      }),
    ).toEqual(
      `https://static.twitchcdn.net/config/settings.${appGroup}.${app}.test.json`,
    );
  });

  it('handles development environment', () => {
    expect(
      dynamicSettingsURLGenerator({
        app,
        appEnvironment: 'development',
        appGroup,
      }),
    ).toEqual(
      `https://static.twitchcdn.net/config/settings.${appGroup}.${app}.development.json`,
    );
  });
});
