import type { Minixperiments } from 'tachyon-experiments';
import type { OnlySnakeCaseProperties } from 'tachyon-type-library';
import type { CamelCasedProperties } from 'type-fest';

export type DynamicSettingsEnvironment = 'development' | 'production' | 'test';

export type DynamicSettingsBase = {
  environment: DynamicSettingsEnvironment;
  experiments: Minixperiments;
  spadeUrl: string;
};

/**
 * Raw dynamic settings payload before we verify the spade url, environments,
 * and experiments
 */
// we treat all values from dynamic settings as potentially undefined for safety
export type DynamicSettingsRawSpadeData<RawCustomDynamicSettings extends {}> =
  Partial<Omit<DynamicSettingsBase, 'spadeUrl'>> &
    Partial<RawCustomDynamicSettings> & {
      spade_url?: string;
    };

// treat all custom values as unknown to force safe type verification
type UnknownCustomDynamicSettings<RawCustomDynamicSettings extends {}> = {
  [key in keyof RawCustomDynamicSettings]: unknown;
};

/**
 * Raw dynamic settings payload before the app processes it into its final form
 */
export type DynamicSettingsRawData<
  RawCustomDynamicSettings extends {},
  SnakeCasedRawCustomDynamicSettings extends OnlySnakeCaseProperties<RawCustomDynamicSettings> = OnlySnakeCaseProperties<RawCustomDynamicSettings>,
> = DynamicSettingsBase &
  UnknownCustomDynamicSettings<SnakeCasedRawCustomDynamicSettings>;

/**
 * Full payload with base and custom settings after processing
 */
export type DynamicSettings<RawCustomDynamicSettings extends {}> =
  CamelCasedProperties<OnlySnakeCaseProperties<RawCustomDynamicSettings>> &
    DynamicSettingsBase;

/**
 * Function for validating and transforming raw dynamic settings values into
 * their safe processed form. Accepts snake-cased raw values and returns
 * camel-cased processed values.
 */
export type DynamicSettingsAppProcessor<RawCustomDynamicSettings extends {}> = (
  data: DynamicSettingsRawData<RawCustomDynamicSettings>,
) => DynamicSettings<RawCustomDynamicSettings>;
