// All platforms must have `web` somewhere in them in order to trigger the
// correct side-effects in player-core
/* eslint-disable typescript-sort-keys/string-enum */
export enum Platform {
  Unknown = 'unknown_web',
  // Tomorrow
  MobileWeb = 'mobile_web',
  Web = 'web',
  Woodstock = 'woodstock_web',
  // Valence
  Prospero = 'prospero_web',
  // Starshot
  // All starshot platforms must end with `_tv` in order to trigger the correct
  // behavior from the recs service
  StarshotDev = 'dev_web_tv',
  // must stay in sync with the `Tachyon Staging` value defined in settings.kts
  StarshotStaging = 'staging_web_tv',
  StarshotWeb = 'web_tv',
  LG = 'lg_web_tv',
  Samsung = 'samsung_web_tv',
  Vizio = 'vizio_web_tv',
  Vestel = 'vestel_web_tv',
  PS4 = 'playstation4_web_tv',
  Switch = 'switch_web_tv',
  // The Twitch app for Android TV
  AndroidTV = 'androidtv_web_tv',
  // The Twitch app for Fire TV
  FireTV = 'firetv_web_tv',
}
