import { Enum } from 'tachyon-utils-ts';
import { Platform } from '.';

describe('Platform', () => {
  describe.each(Enum.entries(Platform))(`%s (%s)`, (_, stringVal) => {
    it('includes web in its value', () => {
      expect(stringVal).toContain('web');
    });

    it('ends with _tv if tv is present', () => {
      expect(
        !stringVal.includes('tv') || stringVal.endsWith('_tv'),
      ).toBeTruthy();
    });
  });
});
