import { Platform } from './Platform';
import { useStaticEnvironment } from './useStaticEnvironment';

// istanbul ignore next: trivial
export function usePublicPlatformName(): string {
  const {
    common: { platform },
  } = useStaticEnvironment();

  // Produce a user-facing value for the platform that we can present in the
  // settings, for the purposes of customers sharing their platform to CS
  // to better help with diagnosing issues.
  //
  // We omit stuff like "web_tv" from the end since users don't need to know
  // that the app is a web app.
  switch (platform) {
    case Platform.Unknown:
      return 'unknown';
    case Platform.MobileWeb:
      return 'mobileweb';
    case Platform.Web:
      return 'web';
    case Platform.Woodstock:
      return 'woodstock';
    case Platform.Prospero:
      // Prospero is an internal name for the PS5 dev toolchain.
      // Valence is our Twitch internal name for that application.
      return 'valence';
    case Platform.StarshotDev:
      return 'starshot_dev';
    case Platform.StarshotStaging:
      return 'starshot_staging';
    case Platform.StarshotWeb:
      return 'starshot';
    case Platform.LG:
      return 'lg';
    case Platform.Samsung:
      return 'samsung';
    case Platform.Vizio:
      return 'vizio';
    case Platform.Vestel:
      // Vestel would like for us to not expose the name Vestel to users since
      // its a manufacturer that is under the hood of many different consumer
      // facing brands
      return 'stellar';
    case Platform.PS4:
      return 'ps4';
    case Platform.Switch:
      return 'switch';
    case Platform.AndroidTV:
      return 'androidtv';
    case Platform.FireTV:
      return 'firetv';
    default:
      const exhaustive: never = platform;
      return exhaustive;
  }
}
