import type {
  DataScienceNetworkInformation,
  NetworkInformation,
} from 'tachyon-type-library';

/**
 * The fields provided by the global `navigator`.
 */
declare global {
  export interface Navigator {
    /**
     * The standard connection field.
     */
    connection: NetworkInformation;
    /**
     * Deprecated, Mozilla-specific network information.
     */
    mozConnection: NetworkInformation;
    /**
     * Deprecated, Chrome-specific network information.
     */
    webkitConnection: NetworkInformation;
  }
}

/**
 * Function that maps NetworkInformation API data into data science values.
 * Any unavailable attributes are returned as undefined.
 */
export function getNetInfo(): DataScienceNetworkInformation {
  if (typeof navigator === 'undefined') {
    return {
      bandwidth: undefined,
      bandwidth_max: undefined,
      effective_mobile_connection_type: undefined,
      mobile_connection_type: undefined,
      round_trip_time: undefined,
    };
  }

  const connection =
    navigator.connection ||
    navigator.mozConnection ||
    navigator.webkitConnection ||
    ({} as NetworkInformation);

  return {
    bandwidth: connection.downlink,
    bandwidth_max: connection.downlinkMax,
    effective_mobile_connection_type: connection.effectiveType,
    mobile_connection_type: connection.type,
    round_trip_time: connection.rtt,
  };
}
