import { datatype } from 'faker';
import type { NetworkInformation } from 'tachyon-type-library';
import { ConnectionType, EffectiveConnectionType } from 'tachyon-type-library';
import { Enum } from 'tachyon-utils-ts';
import { getNetInfo } from '.';

describe('getNetInfo', () => {
  afterEach(() => {
    // @ts-expect-error: tests
    delete navigator.connection;
  });

  it('returns object with undefined attributes when connection is not available', () => {
    expect(getNetInfo()).toEqual({
      bandwidth: undefined,
      bandwidth_max: undefined,
      effective_mobile_connection_type: undefined,
      mobile_connection_type: undefined,
      round_trip_time: undefined,
    });
  });

  it('maps network information API data when it is available', () => {
    const networkInformation: NetworkInformation = {
      downlink: datatype.number(),
      downlinkMax: datatype.number(),
      effectiveType: Enum.values(EffectiveConnectionType)[
        datatype.number(4) - 1
      ],
      rtt: datatype.number(),
      type: Enum.values(ConnectionType)[datatype.number(8) - 1],
    };
    navigator.connection = networkInformation;

    expect(getNetInfo()).toEqual({
      bandwidth: networkInformation.downlink,
      bandwidth_max: networkInformation.downlinkMax,
      effective_mobile_connection_type: networkInformation.effectiveType,
      mobile_connection_type: networkInformation.type,
      round_trip_time: networkInformation.rtt,
    });
  });
});
