import { datatype, lorem, random } from 'faker';
import type { FC } from 'react';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import type { StaticEnvironmentContext } from '../EnvironmentRoot';
import {
  defaultStaticEnvironmentContext,
  staticEnvironmentContext,
} from '../EnvironmentRoot';
import { Platform } from '../Platform';
import type { StaticEnvironmentProps } from '.';
import { withStaticEnvironment } from '.';

describe(withStaticEnvironment, () => {
  const mockEnvContext: StaticEnvironmentContext = {
    ...defaultStaticEnvironmentContext,
    common: {
      appEnvironment: 'development',
      appVersion: datatype.uuid(),
      clientApp: lorem.word(),
      language: random.locale(),
      platform: Platform.Unknown,
    },
  };

  const TestComponent: FC<StaticEnvironmentProps> = () => null;
  const WrappedComponent = withStaticEnvironment(TestComponent);

  const MockProvider: FC = () => {
    return (
      <staticEnvironmentContext.Provider value={mockEnvContext}>
        <WrappedComponent />
      </staticEnvironmentContext.Provider>
    );
  };

  const setup = createMountWrapperFactory(MockProvider);

  it('passes an env prop to the wrapped consumer', () => {
    const { wrapper } = setup();
    expect(wrapper.find(TestComponent)).toHaveProp('staticEnv', mockEnvContext);
  });
});
