# Tachyon ES6 Dependencies List

The list of sub/transistive dependencies used by tachyon packages and apps. This
is consumed by apps whose support matrix includes devices without ES6 support.

## Usage in Tachyon Next.js Applications

Simply add the exported list as the target of `next-transpile-modules`:

```js
const es6Deps = require('tachyon-es6-deps-list');
const withTranspiledModules = require('next-transpile-modules')(es6Deps);
```

## Usage in Other Applications

You'll need to transform the exported list into a regex for your bundler. In
webpack, this would mean augmenting your appropriate loader (babel/etc) to not
ignore these specific node modules. There are libraries that help with this,
such as
[babel-loader-exclude-node-modules-except](https://www.npmjs.com/package/babel-loader-exclude-node-modules-except).

## Managing the list

Additions to the list will happen naturally as we add new packages and then test
apps in older browsers. For removal (especially of transistive dependencies),
use `yarn why <package>` to see if dependencies are actually still in use. This
could occur during occasional audits of this list, but there is no downside to
listing unused modules in this list (since this ultimately populates a regex).
