module.exports = {
  create: (context) => ({
    Identifier: (node) => {
      // find Bowser.getParser
      if (
        node.name === 'getParser' &&
        node.parent.object &&
        node.parent.object.name === 'Bowser'
      ) {
        const userAgentArgument = node.parent.parent.arguments?.[0];
        // if no args, probably being mocked in tests
        // otherwise verify that we're using the proper `||` fallback to BOWSER_USER_AGENT_FALLBACK
        // ('' will also cause Bowser to throw)
        if (
          userAgentArgument &&
          (userAgentArgument.type !== 'LogicalExpression' ||
            (userAgentArgument.operator !== '||' &&
              userAgentArgument.right.name !== 'BOWSER_USER_AGENT_FALLBACK'))
        ) {
          context.report({
            message:
              'Calls to Bowser.getParser should have BOWSER_USER_AGENT_FALLBACK from tachyon-utils as a `||` fallback to prevent crashes',
            node,
          });
        }
      }
    },
  }),
};
