module.exports = {
  create: (context) => ({
    ImportDeclaration: ({ source }) => {
      if (source?.type === 'Literal') {
        context.options[0].forEach((targetDir) => {
          if (source.value.startsWith(targetDir)) {
            context.report({
              message:
                'Use relative imports / barrel files instead of aliased absolute imports',
              node: source,
            });
          }
        });
      }
    },
  }),
};
