module.exports = {
  create: (context) => {
    const comments = context.getSourceCode().getAllComments();
    const { noEmptyDisables = false, rules = [] } = context.options[0];

    comments.forEach(({ loc, value }) => {
      if (value.includes('eslint-disable')) {
        rules.forEach((rule) => {
          if (value.includes(rule)) {
            context.report({
              loc,
              message: `Disabling ${rule} via magic comment is not allowed.`,
            });
          }
        });

        if (noEmptyDisables) {
          if (value.match(/^\s*eslint-disable-next-line\s*$/)) {
            context.report({
              loc,
              message:
                'Disabling all rules are not allowed. List individual rules instead.',
            });
          } else if (value.match(/^\s*eslint-disable(-line)?\s*$/)) {
            context.report({
              data: loc.start,
              // report these at the very start of the file so that they aren't
              // disabled by the very magic comment they are trying to police
              loc: {
                column: 0,
                line: 0,
              },
              message:
                'Disabling all rules are not allowed at line {{line}}:{{column}}. List individual rules instead.',
            });
          }
        }
      }
    });

    return {};
  },
};
