module.exports = {
  create: (context) => ({
    Identifier: (node) => {
      if (node.name === 'mockClear') {
        context.report({
          message:
            'If you need to clear an implementation, use mockReset(). Otherwise remove this as Jest is configured to clear all mocks between tests.',
          node: node.parent,
        });
      }
      if (node.name === 'clearAllMocks') {
        context.report({
          message:
            'If you need to clear all implementations, use jest.resetAllMocks(). Otherwise remove this as Jest is configured to clear all mocks between tests.',
          node: node.parent,
        });
      }
    },
  }),
};
